/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine;

import java.util.ArrayList;
import java.util.List;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.util.ComparableComparator;

public class CollectionElement {
    private String m_name;
    private Object m_value;
    private Object m_expectedValue;
    private ComparableComparator m_comparator;
    private String m_description;
    private List<ErrorDescription> m_errorDescriptionList = new ArrayList<ErrorDescription>();
    private int m_status = 5;
    private String m_node = null;

    public CollectionElement(String name, Object value, Object expectedValue, ComparableComparator comparator, String description, int status) {
        this.m_name = name;
        this.m_value = value;
        this.m_expectedValue = expectedValue;
        this.m_comparator = comparator;
        this.m_description = description;
        this.m_status = status;
    }

    public CollectionElement(String name, String node, Object value, Object expectedValue, ComparableComparator comparator, String description, String statusStr) {
        this.m_name = name;
        this.m_value = value;
        this.m_expectedValue = expectedValue;
        this.m_comparator = comparator;
        this.m_description = description;
        this.m_node = node;
        this.m_status = "SUCCESSFUL".equals(statusStr) ? 1 : ("OPERATION_FAILED".equals(statusStr) ? 2 : ("VERIFICATION_FAILED".equals(statusStr) ? 3 : ("VERIFICATION_WARNING".equals(statusStr) ? 4 : 5)));
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public Object getValue() {
        return this.m_value;
    }

    public void setValue(Object value) {
        this.m_value = value;
    }

    public Object getExpectedValue() {
        return this.m_expectedValue;
    }

    public void setExpectedValue(Object expectedValue) {
        this.m_expectedValue = expectedValue;
    }

    public ComparableComparator getComparator() {
        return this.m_comparator;
    }

    public void setComparator(ComparableComparator comparator) {
        this.m_comparator = comparator;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public String getNode() {
        return this.m_node;
    }

    public List<ErrorDescription> getErrorDescriptionList() {
        return this.m_errorDescriptionList;
    }

    public void addErrorDescription(ErrorDescription errDesc) {
        this.m_errorDescriptionList.add(errDesc);
    }

    public int getStatus() {
        return this.m_status;
    }

    public String getStatusString() {
        if (this.m_status == 1) {
            return "SUCCESSFUL";
        }
        if (this.m_status == 2) {
            return "OPERATION_FAILED";
        }
        if (this.m_status == 3) {
            return "VERIFICATION_FAILED";
        }
        if (this.m_status == 4) {
            return "VERIFICATION_WARNING";
        }
        return "UNDEFINED";
    }

    public void setStatus(int status) {
        this.m_status = status;
    }
}

